﻿using DavidJalbert;
using UnityEngine;
using UnityEngine.UI;

public class PotentialKineticEnergyScript : MonoBehaviour
{
    [SerializeField] TinyCarController Car;
    [SerializeField] Transform SphereCast;
    [SerializeField] LayerMask GroundLayer;
    [SerializeField] Slider PotentialEnergySlider;
    [SerializeField] Slider KineticEnergyEnergySlider;
    [SerializeField] Slider ThermalSlider;
    [SerializeField] Slider VelocitySlider;
    [SerializeField] float ThermalSpeed;
    [SerializeField] float lerpSpeed = 5f;
    [SerializeField] bool CanExplode;
    [SerializeField] float ThermalSliderOnGround = 5;
    float _speedFieldOfView = 5;
    int minFov = 60;
    int maxFov = 70;

    float _triggerHeight;
    float _peakPotential;
    bool _inTrigger;

    bool isExplode;


    Camera _camera;

    private void Start()
    {
        isExplode = false;
        _camera = Camera.main;
    }
    private void OnCollisionEnter(Collision collision)
    {
        if (collision.collider.attachedRigidbody && Input.GetAxis("Vertical") != 0)
        {
            ThermalSlider.value += ThermalSliderOnGround;

            if (CanExplode)
            {
                if (!isExplode)
                {
                    GetComponentInParent<CarExplode>().enabled = true;
                    isExplode = true;
                }
            }
        }
    }
    private void OnTriggerEnter(Collider other)
    {

        if (other.CompareTag("Edge"))
        {
            _triggerHeight = other.transform.position.y;
            PotentialEnergySlider.maxValue = _triggerHeight;
            KineticEnergyEnergySlider.maxValue = _triggerHeight;

            _peakPotential = Car.transform.position.y;
            _inTrigger = true;
        }
    }

    private void OnTriggerExit(Collider other)
    {
        if (other.CompareTag("Edge"))
            _inTrigger = false;
    }

    private void Update()
    {
        VelocitySlider.value = Car.getBody().velocity.magnitude;

        float targetPotential = 0f;
        float targetKinetic = 0f;

        if (_inTrigger )
        {
            float potential = Mathf.Clamp(Car.transform.position.y, 0, _triggerHeight);
            targetPotential = potential;

            if (potential > _peakPotential)
                _peakPotential = potential;

            targetKinetic = (potential < _peakPotential) ? _peakPotential - potential : 0f;
        }
        else
        {
            if (IsGrounded())
            {
                targetPotential = 0f;
                targetKinetic = 0f;
            }
        }

            PotentialEnergySlider.value = Mathf.Lerp(PotentialEnergySlider.value, targetPotential, lerpSpeed * Time.deltaTime);
        KineticEnergyEnergySlider.value = Mathf.Lerp(KineticEnergyEnergySlider.value, targetKinetic, lerpSpeed * Time.deltaTime);

        if(Car.getBody().velocity.sqrMagnitude > 1)
            ThermalSlider.value = Mathf.Lerp(ThermalSlider.value, 100, ThermalSpeed * Time.deltaTime);
        else
            ThermalSlider.value = Mathf.Lerp(ThermalSlider.value, 0, .5f * Time.deltaTime);

        if (Input.GetKey(KeyCode.LeftShift))
        {
            _camera.fieldOfView = Mathf.Lerp(_camera.fieldOfView, maxFov, _speedFieldOfView * Time.deltaTime);
        }
        else
        {
            _camera.fieldOfView = Mathf.Lerp(_camera.fieldOfView, minFov, _speedFieldOfView * Time.deltaTime);
        }

    }

    private bool IsGrounded() => Physics.CheckSphere(SphereCast.position, .5f, GroundLayer);

    
}
